﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CashierCrisis.Behaviors
{
    public class Sequence : Composite
    {
        private int currentChild = 0;

        public override Status Execute(Microsoft.Xna.Framework.GameTime gameTime)
        {
            if (currentChild < Children.Count)
            {
                Behavior behavior = Children[currentChild];

                Status status = behavior.Execute(gameTime);

                switch (status)
                {
                    case Status.Completed:
                        currentChild++;
                        return Running;
                    case Status.Failed:
                        return Failed;
                    case Status.Running:
                        return Running;
                }
            }
            else
            {
                return Completed;
            }

            return base.Execute(gameTime);
        }
    }
}
